function [ W, Points ] = Weights( dud )
%Calculate the Weights for std triangle on uniform 28 point grid
%   This calculates the Weights required for a 28 point quadrature on the
%   std element.

dud = dud + 1;
%(p,q) = {(i-1)/6, (k-1)/6}: k=1:7 and i=1:8-k}
%Visually these are 7 points on the 'bottom' leg and decreases by 1 along
%the rows up to the top vertex. The appropriate 'weights' are extracted
%below and together they evaluate the num quad for \int_{\tri} PdA

%The basis is ordered like {1, x, y, x^2, xy , y^2, x^3,
%x^2y, xy^2, y^3, x^4, x^3y, x^2y^2,x^1y^3,y^4,x^5,x^4y, x^3y^2,x^2y^3,xy^4,
%y^5, x^6,x^5y,x^4y^2,x^3y^3,x^2y^4,xy^5,y^6}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%All this to find the weight coefficients W

%The equation for the weights is  W *PEval = \int P; W is 1 x 28 and PEval
%is 28 x 1.  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Build the right side

%The formulas:
%\int x^iy^j = 1/(j+1)\sum^{j+1}_{k=0} nCr(j+1,k)*(-1)^k*1/(k+i+1);
%\int x^i = \int y^i = 1/(i+1)*1/(i+2);

b = zeros(1,28);
b(1,1) = 1/2; %basis funct: 1

b(1,2) = 1/6; %basis funct: x

b(1,3) = 1/6; %basis funct: y

b(1,4) = 1/24; %basis funct: xy 

b(1,5) = 1/3*1/4; %basis funct: x^2

b(1,6) = 1/3*1/4; %basis funct: y^2

b(1,7) = 1/4*1/5; %basis funct: x^3

b(1,8) = 1/60;%basis funct: x^2*y

b(1,9) = 1/60; %basis funct: xy^2

b(1,10) = 1/4*1/5; %basis funct y^3

b(1,11) = 1/5*1/6; %basis funct: x^4

b(1,12) = 1/120; %basis funct: x^3y

b(1,13) = 1/180;%basis funct: x^2y^2

b(1,14) = 1/120;%basis funct: xy^3

b(1,15) = 1/5*1/6; %basis funct:y^4

b(1,16) = 1/6*1/7; %basis funct: x^5

b(1,17) = 1/210;%basis funct: x^4 y

b(1,18) = 1/420;%basis funct:x^3y^2

b(1,19) = 1/420;%basis funct:x^2y^3

b(1,20) = 1/210;%basis funct:x^1y^4

b(1,21) = 1/6*1/7;%basis funct: y^5

b(1,22) = 1/7*1/8;%basis funct: x^6

b(1,23) = 1/336;%basis funct:x^5*y

b(1,24) = 1/840;%basis funct: x^4*y^2

b(1,25) = 1/1120;%basis funct:x^3y^3

b(1,26) = 1/840;%basis funct:x^2y^4

b(1,27) = 1/336;%basis funct: xy^5

b(1,28) = 1/7*1/8;%basis funct:y^6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Assemble next the matrix of evaluations
%We first list the points being sampled at in (x,y) coordinate form
Points = zeros(28,2);
for k = 1:7
    for i=1:8-k
        posit = 0;
        for c=1:k-1
           posit = posit + 8 - c;
        end
        posit = posit + i;
        Points(posit,1) = (i-1)*1/6;
        Points(posit,2) = (k-1)/6;
    end
end

%Now we evaluate the basis polynomials at these points:
Eval = zeros(28,28);
Eval(:,1) = 1; % 1
Eval(:,2) = Points(:,1); %x
Eval(:,3) = Points(:,2); %y
Eval(:,5) = Points(:,1).^2; %x^2
Eval(:,4) = Points(:,1).*Points(:,2); %xy
Eval(:,6) = Points(:,2).^2; %y^2
Eval(:,7) = Points(:,1).^3; %x^3
Eval(:,8) = Points(:,1).^2.*Points(:,2); %x^2y
Eval(:,9) = Points(:,1).*Points(:,2).^2; %xy^2
Eval(:,10) = Points(:,2).^3; %y^3
Eval(:,11) = Points(:,1).^4; %x^4
Eval(:,12) = Points(:,1).^3.*Points(:,2); %x^3y
Eval(:,13) = Points(:,1).^2.*Points(:,2).^2; %x^2y^2
Eval(:,14) = Points(:,1).*Points(:,2).^3; %xy^3
Eval(:,15) = Points(:,2).^4; %y^4
Eval(:,16) = Points(:,1).^5; %x^5
Eval(:,17) = Points(:,1).^4.*Points(:,2); %x^4 y
Eval(:,18) = Points(:,1).^3.*Points(:,2).^2; %x^3y^2
Eval(:,19) = Points(:,1).^2.*Points(:,2).^3; %x^2y^3
Eval(:,20) = Points(:,1).*Points(:,2).^4; %xy^4
Eval(:,21) = Points(:,2).^5; %y^5
Eval(:,22) = Points(:,1).^6; %x^6
Eval(:,23) = Points(:,1).^5.*Points(:,2); %x^5y
Eval(:,24) = Points(:,1).^4.*Points(:,2).^2; %x^4y^2
Eval(:,25) = Points(:,1).^3.*Points(:,2).^3; %x^3y^3
Eval(:,26) = Points(:,1).^2.*Points(:,2).^4; %x^2y^4
Eval(:,27) = Points(:,1).*Points(:,2).^5; %xy^5
Eval(:,28) = Points(:,2).^6; %y^6


W = Eval'\b'; %This W is our desired weights but transposed
W = W'; %These are desired weights. Ie W*PEval = b. W is 1 x 28 and PEval 28 x 1



end

